;========================================================================================================
; Vertical Nanowire Gate All Around P-type Junctionless Nanotransistor
; SDE command file: jlnt_pmos
;========================================================================================================
;
;========================================================================================================
; Geometry, doping and mesh refinement parameters
;========================================================================================================
; dimensions along x (horizontal, channel direction) are indicated as "lengths"
; dimensions along y (vertical direction) are indicated as "thicknesses"
; increasing y values are plotted from top to bottom (!!)
;
; Nanowire DIAMETER = 27 nm
; Nanowire LENGTH = 78 nm
; Oxide THICKNESS = 5 nm
; Gate LENGTH = 18 nm
; Top spacer LENGTH = 45 nm
; Bottom spacer LENGTH = 70 nm

(define nw_radius 135e-4)
(define ox_radius 185e-4)
(define bot_spacer 70e-3)
(define gat_spacer 88e-3)
(define top_spacer 133e-3)
(define gate_contact 79e-3)

; VERSION 3
; The silicided source/drain contacts have been removed. Now the contacts are defined directly on the 
; nanowire. The nanowire is now divided in three portions: bottom (70 nm), gate (18 nm) and top (45 nm).
; Contacts have been redefined accordingly and - important - they must be defined as Schottky in sdevice
;
; VERSION 4
; The length of the nanowire is hardcoded!! Commented variables not used anymore. Remember to define
; correctly the ox_radius: it always must be equal to nw_radius + 50 because the oxide thickness is 5 nm.
; The nanowire oxide is now divided in three portions in order to define the new gate contact, without
; the metallic line. The central portion of the oxide is define as gate contact.
;
; VERSION 5
; Added parameters to model the nanowire length. The variable gate_contact is for picking the correct face
; on the nanowire to define the gate contact. It should be equal to top_spacer + gate_length/2.
; gat_spacer = bot_spacer + gate_length
; top_spacer = bot_spacer + gate_length + top_spacer_length = nanowire_length
; gate_contact = bot_spacer + gate_length/2
; ox_radius = nw_radius + ox_thickness
;
; VERSION 6
; Put back the metallic gate line, now with improved scripting. Added flag -AI to meshing command to prevent
; Unable to save dataset 'TrapOccupation_0(Ac,Le)':
; interface 'core/oxide' not found in grid file jlnt_pmos_msh.tdr !

;========================================================================================================
; Definition of the geometry
;========================================================================================================
; Porzione inferiore nanowire
(define A (sdegeo:create-cylinder (position 0 0 0) (position bot_spacer 0 0)  			nw_radius "Silicon" "core"))

; Porzione sotto gate nanowire
(define B (sdegeo:create-cylinder (position bot_spacer 0 0) (position gat_spacer 0 0)  	nw_radius "Silicon" "core"))

; Porzione superiore nanowire
(define C (sdegeo:create-cylinder (position gat_spacer 0 0) (position top_spacer 0 0)  	nw_radius "Silicon" "core"))

(sdegeo:bool-unite (list A B C))

; Creazione dell'ossido
(sdegeo:set-default-boolean "XX")
(define A (sdegeo:create-cylinder (position 0 0 0) (position top_spacer 0 0)  ox_radius "SiO2" "oxide"))
(define B (sdegeo:create-cylinder (position 0 0 0) (position top_spacer 0 0)  nw_radius "SiO2" "oxide"))
(sdegeo:bool-subtract (list A B))

; Creazione del gate (gate length = 18.0 nm)
(define A (sdegeo:create-cuboid (position bot_spacer -60e-3 -60e-3) (position gat_spacer 60e-3 250e-3) "Metal" "gate"))
(define B (sdegeo:create-cylinder (position 0 0 0) (position top_spacer 0 0)  ox_radius "SiO2" "gate"))
(sdegeo:bool-subtract (list A B))

;========================================================================================================
; Definition of the contacts
;========================================================================================================
; Gate contact
(sdegeo:define-contact-set "Gate" 4 (color:rgb 0 0 1) "##")
(sdegeo:set-current-contact-set "Gate")
(sdegeo:define-3d-contact (list (car (find-face-id (position gate_contact 0 0.25)))) "Gate")

; Source contact
(sdegeo:define-contact-set      "Source"    4 (color:rgb  1 0 0) "##")
(sdegeo:set-current-contact-set "Source")
(sdegeo:define-3d-contact (list (car (find-face-id (position 0 0.0 0.0)))) "Source")

; Drain contact
(sdegeo:define-contact-set      "Drain"     4 (color:rgb 0 1 0) "##")
(sdegeo:set-current-contact-set "Drain")
(sdegeo:define-3d-contact (list (car (find-face-id (position top_spacer 0.0 0.0)))) "Drain")

;========================================================================================================
; Defining doping profiles
;========================================================================================================
; Nanowire doping
(sdedr:define-constant-profile "ConstantProfileDefinition_1" "BoronActiveConcentration" 2.2e18)
(sdedr:define-constant-profile-region "Doping_p_type" "ConstantProfileDefinition_1" "core" 0 "Replace")

;========================================================================================================
; Defining mesh parameters
;========================================================================================================
(sdedr:define-refinement-size "RefinementDefinition_1" 1e-2 1e-2 1e-2 1e-3 1e-3 1e-3 )
(sdedr:define-refinement-placement "RefinementPlacement_silicide" "RefinementDefinition_1" (list "material" "Metal" ) )
(sdedr:define-refinement-size "RefinementDefinition_1" 1e-2 1e-2 1e-2 1e-3 1e-3 1e-3 )
(sdedr:define-refinement-placement "RefinementPlacement_silicide" "RefinementDefinition_1" (list "material" "SiO2" ) )
(sdedr:define-refinement-size "RefinementDefinition_2" 1e-2 1e-2 1e-2 1e-3 1e-3 1e-3 )
(sdedr:define-refinement-placement "RefinementPlacement_nanowire" "RefinementDefinition_2" (list "material" "Silicon" ) )
(sde:enable-facet-options-usage)
(sde:modify-facet-options sde-facet-opts "surface_tol" -10 "normal_tol" 25 "aspect_ratio" 0 "max_edge_length" 0.004)

;========================================================================================================
; Generate mesh
;========================================================================================================
(sde:set-meshing-command "snmesh")
(sde:build-mesh "-AI" "jlnt_pmos")
